﻿using System;
using System.Collections.Generic;
using System.Text;
 
using IndianHealthService.BMXNet.Services;
using IndianHealthService.BMXNet.WinForm.Model;

namespace IndianHealthService.BMXNet.WinForm.Services
{
    internal class EventRegistry 
    {

        private Log _logger = new NullLog();

        public Log Logger
        {
            get { return _logger; }
            set { _logger = value; }
        }

        private Dictionary<String, List<WinSession>> _registry = new Dictionary<string, List<WinSession>>();

        public Dictionary<String, List<WinSession>> Registry
        {
            get { return _registry; }
            set { _registry = value; }
        }

        public void Subscribe(String anEvent, WinSession aReceiver)
        {
            this.Logger.Log("Event", "Subscribing", aReceiver.ToString() + " subsribed to " + anEvent);
            List<WinSession> registrations = null;

            if (!this.Registry.TryGetValue(anEvent, out registrations))
            {
                registrations = new List<WinSession>();
                this.Registry[anEvent] = registrations;
            }

            if (registrations.Contains(aReceiver))
            {
                this.Logger.Log("Event", "Subscribing", aReceiver.ToString() + " OVER-subscribed to " + anEvent);

            }
            else
            {
                registrations.Add(aReceiver);
                this.Logger.Log("Event", "Subscribing", aReceiver.ToString() + " subscribed to " + anEvent);

            }
        }

        public bool HasSubscribers(string anEvent)
        {
            List<WinSession> registrations = null;

            if (this.Registry.TryGetValue(anEvent, out registrations))
            {
                return registrations.Count > 0;
            }
            else
            {
                return false;
            }
        }


        public void Unsubscribe(String anEvent, WinSession aReceiver)
        {
            List<WinSession> registrations = null;

            if (this.Registry.TryGetValue(anEvent, out registrations))
            {
                if (registrations.Contains(aReceiver))
                {
                    this.Logger.Log("Event", "Subscription", aReceiver.ToString() + " unsubscribed to " + anEvent);
                    registrations.Remove(aReceiver);
                }
                else
                {
                    this.Logger.Log("Event", "Subscription", aReceiver.ToString() + " UNDER-subscribed to " + anEvent);
                }
            }
        }

        public void TriggerEvent(string anEvent, string aStub)
        {
            List<WinSession> registrations = null;
            this.Logger.Log("BMX WIN", "Local Events", anEvent + " ," + aStub);

            if (this.Registry.TryGetValue(anEvent, out registrations))
            {
                foreach (WinSession each in registrations)
                {
                    this.Logger.Log("BMX WIN", "Local Events", each.ToString() + " was called for " + anEvent + "::" + aStub);
                    each.IncomingEventCallback(anEvent, aStub);
                }
            }
        }

    }
}
